local function UpdateBPMs(self)
	local p1 = self:GetChild("BeatsP1")
	local p2 = self:GetChild("BeatsP2")

	local ps1 = GAMESTATE:GetPlayerState(PLAYER_1)
	local ps2 = GAMESTATE:GetPlayerState(PLAYER_2)

	local songPos1 = ps1:GetSongPosition()
	local songPos2 = ps2:GetSongPosition()

	p1:settextf("%.0f",songPos1:GetCurBPS()*60)
	p2:settextf("%.0f",songPos2:GetCurBPS()*60)
end

return Def.ActorFrame{
	Def.SongMeterDisplay{
		StreamWidth=386; -- xxx: old way of doing it
		Stream=Def.Quad{
			InitCommand=cmd(zoomy,14;diffusecolor,color("#FF0000");diffusebottomedge,color("#351E1E");diffusealpha,0.625);
		};
		Tip=Def.Quad{
			InitCommand=cmd(x,1;halign,1;zoomto,2,14;diffusealpha,0.95;fadeleft,0.5);
			OnCommand=cmd(diffuseshift;effectclock,'beat';effectcolor1,color("1,1,1,0.6");effectcolor2,color("1,1,1,1"));
		};
	};

	LoadActor("_frame");

	LoadFont("_eurostile bold 24px")..{
		InitCommand=cmd(zoom,0.5;shadowlength,1.25;maxwidth,700);
		BeginCommand=cmd(playcommand,"Update");
		UpdateCommand=function(self)
			local finaltext = ""
			local song = GAMESTATE:GetCurrentSong()
			if GAMESTATE:IsCourseMode() then
				local course = GAMESTATE:GetCurrentCourse()
				if course then
					finaltext = course:GetDisplayFullTitle()
				end
				if song then
					finaltext = finaltext .. " - "..song:GetDisplayFullTitle()
				end
			else
				if song then
					finaltext = song:GetDisplayFullTitle()
				end
			end
			self:settext(finaltext)
		end;
	};

	Def.ActorFrame{
		Name="BPMSection";
		InitCommand=cmd(y,24;SetUpdateFunction,UpdateBPMs);
		LoadActor("_bpm")..{ InitCommand=cmd(shadowlength,1.5); };

		LoadFont("_xenotron metal 36px")..{
			Name="BeatsP1";
			InitCommand=cmd(x,-44;diffuse,PlayerColor(PLAYER_1);halign,1;zoom,0.6;player,PLAYER_1;shadowlength,1.5);
		};
		LoadFont("_xenotron metal 36px")..{
			Name="BeatsP2";
			InitCommand=cmd(x,44;diffuse,PlayerColor(PLAYER_2);halign,0;zoom,0.6;player,PLAYER_2;shadowlength,1.5);
		};
	};
};